///////////////////////////////////////////////////////////////////////////
//	Copyright(c) 1999-2015, Rejulink Technology LTD, All Rights Reserved
//	Created: 2015/09/19
//
/// @file	 sys_pthread.h
/// @brief	 Thread definition
/// @author  
/// @version 0.1
/// @history
///	  \n xxx 2015/09/19	0.1	Create file
/// @warning no warning
///////////////////////////////////////////////////////////////////////////
#ifndef __SYS_PTHREAD_H__
#define __SYS_PTHREAD_H__

#include "rj_type.h"

typedef struct sys_thread_t sys_thread_t;

typedef int (*sys_start_routine)(void *p_param, int *p_run);

RJ_API sys_thread_t* sys_thread_create(sys_start_routine start_routine, void *p_param, int *p_run);


RJ_API void sys_thread_destroy(sys_thread_t *p_thread, int *p_run);


RJ_API void sys_thread_set_cpu(uint32 cpu_index);

RJ_API int sys_get_pid();


RJ_API int sys_get_tid();

RJ_API void sys_sleep(unsigned int millon_seconds);

typedef struct sys_mutex_t sys_mutex_t;

RJ_API sys_mutex_t* sys_mutex_create();

RJ_API void sys_mutex_destroy(sys_mutex_t *p_mutex);

RJ_API int  sys_mutex_trylock(sys_mutex_t *p_mutex);

RJ_API void sys_mutex_unlock(sys_mutex_t *p_mutex);

#ifndef NDEBUG

RJ_API void sys_my_mutex_lock(sys_mutex_t *p_mutex, const char *p_file, const char *p_func, int line);

#undef sys_mutex_lock
#define sys_mutex_lock(PTR_MUTEX)       sys_my_mutex_lock((PTR_MUTEX), __FILE__, __FUNCTION__, __LINE__)

#undef sys_mutex_trylock
#define sys_mutex_trylock(PTR_MUTEX)    sys_mutex_trylock(PTR_MUTEX)

#undef sys_mutex_unlock
#define sys_mutex_unlock(PTR_MUTEX)     sys_mutex_unlock(PTR_MUTEX)

#else

RJ_API void sys_mutex_lock(sys_mutex_t *p_mutex);
#endif


typedef struct sys_cond_t sys_cond_t;

RJ_API sys_cond_t* sys_cond_create();

RJ_API void sys_cond_destroy(sys_cond_t *p_cond);

RJ_API void sys_cond_signal(sys_cond_t *p_cond);

RJ_API void sys_cond_broadcast(sys_cond_t *p_cond);

RJ_API void sys_cond_wait(sys_cond_t *p_cond, sys_mutex_t *p_mutex);

RJ_API int  sys_cond_timedwait(sys_cond_t *p_cond, sys_mutex_t *p_mutex, uint64 timeout);

typedef struct sys_atomic_t sys_atomic_t;

RJ_API sys_atomic_t* sys_atomic_create();

RJ_API void sys_atomic_destroy(sys_atomic_t *p_atomic);

RJ_API void sys_atomic_set_zero(sys_atomic_t *p_atomic);

RJ_API int sys_atomic_set_value(sys_atomic_t *p_atomic, int value);

RJ_API int sys_atomic_get_value(sys_atomic_t *p_atomic);

RJ_API int sys_atomic_inc(sys_atomic_t *p_atomic);

RJ_API int sys_atomic_dec(sys_atomic_t *p_atomic);

RJ_API int sys_atomic_zero(sys_atomic_t *p_atomic);

RJ_API void sys_atomic_lock(sys_atomic_t *p_atomic);

RJ_API int sys_atomic_try_lock(sys_atomic_t *p_atomic);

RJ_API void sys_atomic_unlock(sys_atomic_t *p_atomic);


#endif // __SYS_PTHREAD_H__
//end
